<?php 
   if(!isset($index)){
      $index = 2;
   }
   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'travivu_medium';
   if(!isset($excerpt_words)){
      $excerpt_words = travivu_get_option('blog_excerpt_limit', 20);
   }
?>

<article id="post-<?php echo esc_attr(get_the_ID()); ?>" class="post post-block-sticky__single">
   
   <div class="post-block-sticky__thumbnail">
      <a href="<?php echo esc_url( get_permalink() ) ?>">
         <?php the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) ); ?>
      </a>
   </div>

   <div class="post-block-sticky__content">
      <?php if( get_the_date() ){ ?>
         <div class="post-block-sticky__date">
            <span class="day"><?php echo esc_html( get_the_date('d')) ?></span>
            <span class="month"><?php echo esc_html( get_the_date('M')) ?></span>
         </div>
      <?php } ?>
      <div class="post-block-sticky__content-inner">
         <h2 class="post-block-sticky__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h2>
         <div class="post-block-sticky__meta">
            <?php  if(comments_open()){ ?>
               <span class="post-block-sticky__comment"><i class="far fa-comments"></i>
                  <?php echo comments_number( esc_html__('0 Comments', 'travivu'), esc_html__('1 Comment', 'travivu'), esc_html__('% Comments', 'travivu') ); ?>
               </span>
            <?php } ?>
            <div class="post-block-sticky__read-more">
               <a href="<?php echo esc_url( get_permalink() ) ?>" aria-label="link">
                  <i class=" ticon-right-arrow-1"></i></a>
            </div>
         </div>
      </div>
   </div>
</article>   

  