<?php
/**
	*
	* @author     Gaviasthemes     
	* @copyright  Copyright (C) 2025 Gaviasthemes. All Rights Reserved.
	* @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
	* 
*/
use Directorist\Multi_Directory;

define('TRAVIVU_THEME_DIR', get_template_directory());
define('TRAVIVU_THEME_URL', get_template_directory_uri());

// Include list of files of theme.
require_once(TRAVIVU_THEME_DIR . '/includes/functions.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/template.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/hook.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/comment.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/metaboxes.php');
require_once(TRAVIVU_THEME_DIR . '/includes/customize.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/menu.php'); 
require_once(TRAVIVU_THEME_DIR . '/includes/elementor/hooks.php');

//Load Woocommerce plugin
if(class_exists('WooCommerce')){
	add_theme_support('woocommerce');
	require_once(TRAVIVU_THEME_DIR . '/includes/woocommerce/functions.php'); 
	require_once(TRAVIVU_THEME_DIR . '/includes/woocommerce/hooks.php'); 
}

add_action('after_setup_theme', 'travivu_after_setup_theme');
function travivu_after_setup_theme(){
	// Load Redux - Theme options framework
	if(class_exists('Redux')){
		require(TRAVIVU_THEME_DIR . '/includes/options/init.php');
		require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-general.php'); 
		require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-styling.php'); 
		require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-page.php'); 
		require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-portfolio.php'); 

		if( class_exists('WTE') ){
			require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-trip-general.php'); 
		}
		if(class_exists('WooCommerce')){
			require_once(TRAVIVU_THEME_DIR . '/includes/options/opts-woo.php'); 
		}
	}
	//	Registry menu
	register_nav_menus( array(
		'primary'      => esc_html__( 'Main menu', 'travivu' ),
	));
}

// TGM plugin activation
if (is_admin()) {
	require_once(TRAVIVU_THEME_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php');
	require(TRAVIVU_THEME_DIR . '/includes/tgmpa/config.php');
}
load_theme_textdomain('travivu', get_template_directory() . '/languages');

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function travivu_widgets_init() {
	register_sidebar(array(
		'name' 				=> esc_html__('Default Sidebar', 'travivu'),
		'id' 					=> 'default_sidebar',
		'description' 		=> esc_html__('Appears in the Default Sidebar section of the site.', 'travivu'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));

	if(class_exists('WooCommerce')){
		register_sidebar( array(
			'name' 				=> esc_html__('WooCommerce Shop Sidebar', 'travivu'),
			'id' 					=> 'woocommerce_sidebar',
			'description' 		=> esc_html__('Appears in the Plugin WooCommerce section of the site.', 'travivu'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget'	 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
		register_sidebar( array(
			'name' 				=> esc_html__('WooCommerce Product Sidebar', 'travivu'),
			'id' 					=> 'woocommerce_product_sidebar',
			'description' 		=> esc_html__('Appears in the Product Single page of the site.', 'travivu'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget'	 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
	}
	register_sidebar(array(
		'name' 				=> esc_html__('After Offcanvas Mobile', 'travivu'),
		'id' 					=> 'offcanvas_sidebar_mobile',
		'description' 		=> esc_html__('Appears in the Offcanvas section of the site.', 'travivu'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	
}
add_action('widgets_init', 'travivu_widgets_init');


function travivu_fonts_url() { 
	$fonts_url = '';
	$fonts     = array();
	$subsets   = '';
	$protocol = is_ssl() ? 'https' : 'http';
	if('off' !== _x('on', 'Plus Jakarta Sans font: on or off', 'travivu')){
		$fonts[] = 'Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800';
	}
	if('off' !== _x('on', 'Covered By Your Grace font: on or off', 'travivu')){
		$fonts[] = 'Covered+By+Your+Grace';
	}
	if($fonts){
		$fonts_url = add_query_arg( array(
			'family' => (implode('&family=', $fonts)),
			'display' => 'swap',
		),  $protocol.'://fonts.googleapis.com/css2');
	}
	return $fonts_url;
}

function travivu_custom_styles() {
	$custom_css = get_option('travivu_theme_custom_styles');
	if($custom_css){
		wp_enqueue_style(
			'travivu-custom-style',
			TRAVIVU_THEME_URL . '/assets/css/custom_script.css'
		);
		wp_add_inline_style('travivu-custom-style', $custom_css);
	}
}
add_action('wp_enqueue_scripts', 'travivu_custom_styles', 9999);

function travivu_init_scripts(){
	global $post;
	$protocol = is_ssl() ? 'https' : 'http';
	if ( is_singular() && comments_open() && get_option('thread_comments') ){
		wp_enqueue_script('comment-reply');
	}

	$theme = wp_get_theme('travivu');
	$theme_version = $theme['Version'];

	wp_enqueue_style('travivu-fonts', travivu_fonts_url(), array(), null );
	
	wp_enqueue_script('bootstrap', TRAVIVU_THEME_URL . '/assets/js/bootstrap.min.js', array('jquery') );
  	wp_enqueue_script('scrollbar', TRAVIVU_THEME_URL . '/assets/js/perfect-scrollbar.jquery.min.js');
	wp_enqueue_script('jquery-magnific-popup', TRAVIVU_THEME_URL . '/assets/js/magnific/jquery.magnific-popup.min.js');
	wp_enqueue_script('jquery-cookie', TRAVIVU_THEME_URL . '/assets/js/jquery.cookie.js', array('jquery'));
	wp_enqueue_script('swiper', TRAVIVU_THEME_URL . '/assets/js/swiper/swiper.min.js');
	wp_enqueue_script('jquery-appear', TRAVIVU_THEME_URL . '/assets/js/jquery.appear.js');
	wp_enqueue_script('travivu-main', TRAVIVU_THEME_URL . '/assets/js/main.js', array('imagesloaded', 'jquery-masonry'));
  
	wp_enqueue_style('dashicons');
	wp_enqueue_style('swiper', TRAVIVU_THEME_URL .'/assets/js/swiper/swiper.min.css');
	wp_enqueue_style('magnific', TRAVIVU_THEME_URL .'/assets/js/magnific/magnific-popup.css');
	wp_enqueue_style('fontawesome', TRAVIVU_THEME_URL . '/assets/css/fontawesome/css/all.min.css');
	wp_enqueue_style('travivu-icon', TRAVIVU_THEME_URL . '/assets/css/icons/style.css');

	wp_enqueue_style('travivu-style', TRAVIVU_THEME_URL . '/style.css');
	wp_enqueue_style('bootstrap', TRAVIVU_THEME_URL . '/assets/css/bootstrap.css', array(), $theme_version , 'all'); 
	wp_enqueue_style('travivu-template', TRAVIVU_THEME_URL . '/assets/css/template.css', array(), $theme_version , 'all');
	
	//WP Travel Engine
	if(class_exists('\WPTravelEngine\Plugin')){ 
		wp_enqueue_style('travivu-booking', TRAVIVU_THEME_URL . '/assets/css/booking.css', array(), $theme_version , 'all');
	}

	//Woocommerce
	if(class_exists('WooCommerce')){
		wp_enqueue_style('travivu-woocoomerce', TRAVIVU_THEME_URL . '/assets/css/woocommerce.css', array(), $theme_version , 'all'); 
		wp_dequeue_script('wc-add-to-cart');
		wp_enqueue_script('wc-add-to-cart', TRAVIVU_THEME_URL . '/assets/js/add-to-cart.js' , array('jquery'));
	}
} 
add_action('wp_enqueue_scripts', 'travivu_init_scripts', 999);




