<?php 
   global $post;

   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'post-thumbnail';
   $excerpt_words = (isset($excerpt_words) && $excerpt_words) ? $excerpt_words : '0';

   $desc = travivu_limit_words($excerpt_words, get_the_excerpt(), '');

   $meta_classes = 'post-two__meta';
   if(empty(get_the_date())){
      $meta_classes = 'post-two__meta schedule-date';
   }
   $author_name = get_the_author_meta( 'display_name', $post->post_author );
   $content_classes = 'post-two__content';
   $content_classes .= has_post_thumbnail() ? ' has-thumbnail' : ' has-no-thumbnail';
?>

   <article id="post-<?php echo esc_attr(get_the_ID()); ?>" <?php post_class('post post-two__single'); ?>>
      <div class="<?php echo esc_attr($content_classes) ?>">
         <div class="<?php echo esc_attr($meta_classes) ?>">
            <div class="post-two__meta-inner">
               <?php if( get_the_date() ){ ?>
                  <span class="post-two__entry-date">
                     <?php echo esc_html( get_the_date('d M')) ?>
                  </span>
               <?php } ?>
               <?php  if(comments_open()){ ?>
                  <span class="post-two__post-comment"><i class="far fa-comments"></i>
                     <?php echo comments_number( esc_html__('0 Comments', 'travivu'), esc_html__('1 Comment', 'travivu'), esc_html__('% Comments', 'travivu') ); ?>
                  </span>
               <?php } ?>
            </div>
         </div>
         <div class="post-two__content-inner">   
            <div class="post-two__infor">
               <?php travivu_posted_on_width_avata(); ?>
            </div> 
            <h3 class="post-two__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h3>
         </div>
         <div class="post-two__read-more">
            <a href="<?php echo esc_url( get_permalink() ) ?>" aria-label="link">
               <span class="btn-text"><?php echo esc_html__( 'Read More', 'travivu') ?></span><i class=" ticon-right-arrow-1"></i></a>
         </div>
      </div>   
      <?php if(has_post_thumbnail()){ ?>
         <div class="post-two__thumbnail">
            <a href="<?php echo esc_url( get_permalink() ) ?>">
               <?php the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) ); ?>
            </a>
         </div>   
      <?php } ?> 
   </article>   

  